<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_InlineMod_Post extends XFCP_sonnbStopSpamHere_ControllerPublic_InlineMod_Post
{
	public function actionDeleteSpam()
	{
		$sonnbSSHInlineModel = $this->getModelFromCache('sonnbStopSpamHere_Model_Inline');
		$sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
		
		if ($this->isConfirmedPost())
		{
			$options = $this->_input->filter(array(
			    'thread_action' => XenForo_Input::STRING,
			    'reason' => XenForo_Input::STRING,
			    'node_id' => XenForo_Input::UINT,
			        
				'delete_messages' => XenForo_Input::UINT,
				'user_action' => XenForo_Input::STRING,
				'ip_action' => XenForo_Input::STRING,
				'posts' => array('array' => true, XenForo_Input::UINT),
				'redirect' => XenForo_Input::STRING,
				'submit_spam' => XenForo_Input::ARRAY_SIMPLE
			));

			$posts = $this->_getPostModel()->getPostsByIds($options['posts']);
			
			$ownerCount = array();
			foreach ($posts AS $post)
			{		
			    if ($post['user_id'] == $sshModel->visitor['user_id'])
			    {
			        return $this->responseRedirect(
        				XenForo_ControllerResponse_Redirect::SUCCESS,
        				$options['redirect'],
        				new XenForo_Phrase('sorry_dave')
        			);
			    }	
			    
				if (!isset($ownerCount[$post['user_id']]))
				{
					$ownerCount[$post['user_id']] = $post['user_id'];
				}
			}
			
			foreach ($ownerCount as $userId)
			{
				switch ($options['user_action'])
				{
					case 'delete':
						$sonnbSSHInlineModel->deleteUser($userId);
						break;
					case 'ban':
						$sonnbSSHInlineModel->banUser($userId);
						break;
					case 'discourage':
						$sonnbSSHInlineModel->discourageUser($userId);
						break;
					case 'nothing':
					default:
						break;
				}
				
				switch ($options['ip_action'])
				{
					case 'ban':
						$sonnbSSHInlineModel->banUserIPs($userId);
						break;
					case 'discourage':
						$sonnbSSHInlineModel->discourageUserIPs($userId);
						break;
					case 'nothing':
					default:
						break;
				}
				
				if ($options['user_action'] != 'delete')
				{
					/*
					 * Process all user's threads
					 */
					switch ($options['thread_action'])
					{
					    case 'soft':
					    case 'hard':
						    $sonnbSSHInlineModel->deleteAllUserThreads($userId, $options['thread_action'], $options['reason']);
						    break;
					    case 'move':
					        $sonnbSSHInlineModel->moveAllUserThreads($userId, $options['node_id']);
					        break;
					    case 'nothing':
					    default:
					        break;					        
					}
					
					/*
					 * Delete all user's posts
					 */
					if ($options['delete_messages'])
					{
						$sonnbSSHInlineModel->deleteAllUserPosts($userId);
					}
				}
				
				if ($options['submit_spam'])
				{
					$sonnbSSHInlineModel->submitUserByUserId($userId, $options['submit_spam']);
				}
			
				$sonnbSSHInlineModel->logDeleteSpamForUser($userId, $options);
			}
			
			/*
			 * Delete post only if mass deletion actions were not performed
			 */
			if (!$options['delete_messages'])
			{
				$sonnbSSHInlineModel->deletePosts($options['posts']);
			}
			
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				$options['redirect'],
				new XenForo_Phrase('sonnbStopSpamHere_your_action_was_performed_successful')
			);
		}
		else // show confirmation dialog
		{
			$postIds = $this->getInlineModIds();

			$handler = $this->_getInlineModPostModel();
			
			if (!$handler->canDeletePosts($postIds, 'soft', $errorPhraseKey))
			{
				throw $this->getErrorOrNoPermissionResponseException($errorPhraseKey);
			}

			$redirect = $this->getDynamicRedirect();

			if (!$postIds)
			{
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					$redirect
				);
			}

			$posts = $this->_getPostModel()->getPostsByIds($postIds, array('join' => XenForo_Model_Post::FETCH_THREAD));
			
			$firstPostCount = 0;
			$ownerCount = array();
			
			foreach ($posts AS $post)
			{
				if ($post['post_id'] == $post['first_post_id'])
				{
					$firstPostCount++;
				}
				
				if (!isset($ownerCount[$post['user_id']]))
				{
					$ownerCount[$post['user_id']] = $post['user_id'];
				}
			}
			
			$showUserInfo = count($ownerCount) == 1;
			
			$viewParams = array(
				'postIds' => $postIds,
				'postCount' => count($postIds),
				'redirect' => $redirect,
				'showUserInfo' => $showUserInfo,
				'firstPostCount' => $firstPostCount,
			    'nodeOptions' => $this->getModelFromCache('XenForo_Model_Node')->getViewableNodeList(),
				'services' => array_keys($sshModel->services)
			);
			
			if ($showUserInfo)
			{
				$userModel = $this->getModelFromCache('XenForo_Model_User');
				$user = $userModel->getUserById(key($ownerCount), array('join' => XenForo_Model_User::FETCH_LAST_ACTIVITY));
				
				if ($user)
				{
					$registrationIps = $userModel->getRegistrationIps($user['user_id']);
					$userIps = $sonnbSSHInlineModel->getUserIps($user['user_id']);
					
					$viewParams['user'] = $user;
					$viewParams['registrationIps'] = $registrationIps;
					$viewParams['lastLoginIp'] = reset($userIps);
				}
			}

			return $this->responseView(
				'sonnbStopSpamHere_ViewPublic_InlineMod_Post_Delete', 
				'sonnbStopSpamHere_inline_delete', 
				$viewParams
			);
		}
	}
}